<?php
echo "=== DIAGNÓSTICO DEL SISTEMA CRM ===\n\n";

// 1. Verificar archivos principales
echo "1. VERIFICACIÓN DE ARCHIVOS:\n";
$archivos = ['config.php', 'database.sql', 'contactos.php', 'dashboard.php'];
foreach ($archivos as $archivo) {
    if (file_exists($archivo)) {
        echo "✅ $archivo - " . number_format(filesize($archivo)) . " bytes\n";
    } else {
        echo "❌ $archivo - NO ENCONTRADO\n";
    }
}

echo "\n2. CONFIGURACIÓN PHP:\n";
echo "Versión PHP: " . phpversion() . "\n";

$extensiones = ['pdo', 'pdo_mysql', 'mysqli'];
foreach ($extensiones as $ext) {
    if (extension_loaded($ext)) {
        echo "✅ $ext\n";
    } else {
        echo "❌ $ext - NO DISPONIBLE\n";
    }
}

echo "\n3. TEST DE CONEXIÓN A BASE DE DATOS:\n";

// Probar diferentes configuraciones
$configs = [
    'actual' => [
        'host' => 'localhost',
        'dbname' => 'v34sdfaas213_crmlead',
        'username' => 'v34sdfaas213_crmlead',
        'password' => '=?u_8W=IOU1^P@;X'
    ],
    'local_root' => [
        'host' => 'localhost',
        'dbname' => 'crmlead',
        'username' => 'root',
        'password' => ''
    ],
    'local_sistema' => [
        'host' => 'localhost',
        'dbname' => 'sistema200001',
        'username' => 'root',
        'password' => ''
    ]
];

foreach ($configs as $name => $config) {
    echo "\nProbando configuración '$name':\n";
    echo "Host: {$config['host']}\n";
    echo "Database: {$config['dbname']}\n";
    echo "Username: {$config['username']}\n";
    
    try {
        $dsn = "mysql:host={$config['host']};dbname={$config['dbname']};charset=utf8mb4";
        $pdo = new PDO($dsn, $config['username'], $config['password'], [
            PDO::ATTR_ERRMODE => PDO::ERRMODE_EXCEPTION,
            PDO::ATTR_TIMEOUT => 5
        ]);
        
        echo "✅ CONEXIÓN EXITOSA!\n";
        
        // Verificar tablas
        $tables = $pdo->query("SHOW TABLES")->fetchAll(PDO::FETCH_COLUMN);
        echo "Tablas encontradas: " . count($tables) . "\n";
        
        $required = ['usuarios', 'contactos'];
        foreach ($required as $table) {
            if (in_array($table, $tables)) {
                echo "✅ Tabla '$table' existe\n";
            } else {
                echo "❌ Tabla '$table' no existe\n";
            }
        }
        
        // Si llegamos aquí, esta configuración funciona
        echo "\n*** CONFIGURACIÓN VÁLIDA ENCONTRADA ***\n";
        echo "Usar esta configuración en config.php:\n";
        echo "DB_HOST: {$config['host']}\n";
        echo "DB_NAME: {$config['dbname']}\n";
        echo "DB_USER: {$config['username']}\n";
        echo "DB_PASS: " . (empty($config['password']) ? '(vacía)' : $config['password']) . "\n";
        break;
        
    } catch (PDOException $e) {
        echo "❌ Error: " . $e->getMessage() . "\n";
    }
}

echo "\n4. VERIFICACIÓN DE SERVIDOR MYSQL:\n";
try {
    $pdo = new PDO("mysql:host=localhost", 'root', '', [
        PDO::ATTR_ERRMODE => PDO::ERRMODE_EXCEPTION,
        PDO::ATTR_TIMEOUT => 5
    ]);
    
    echo "✅ Servidor MySQL accesible\n";
    
    $databases = $pdo->query("SHOW DATABASES")->fetchAll(PDO::FETCH_COLUMN);
    echo "Bases de datos disponibles:\n";
    foreach ($databases as $db) {
        echo "  - $db\n";
    }
    
} catch (PDOException $e) {
    echo "❌ No se puede conectar al servidor MySQL: " . $e->getMessage() . "\n";
    echo "Posibles soluciones:\n";
    echo "1. Verificar que MySQL/MariaDB esté ejecutándose\n";
    echo "2. Verificar credenciales de acceso\n";
    echo "3. Verificar configuración del servidor\n";
}

echo "\n=== FIN DEL DIAGNÓSTICO ===\n";
?>