# Sistema CRM - Vortex Agencia

Sistema de gestión de contactos (CRM) desarrollado con PHP, MySQL/MariaDB y Bootstrap. Incluye autenticación de usuarios, dashboard con estadísticas, gestión de contactos y panel de administración.

## Características

- ✅ **Autenticación**: Login y registro para usuarios y administradores
- ✅ **Dashboard**: Estadísticas de contactos por usuario y fechas
- ✅ **Gestión de Contactos**: Crear, editar y eliminar contactos
- ✅ **Panel de Administración**: Estadísticas detalladas por usuario
- ✅ **Diseño Responsive**: Compatible con dispositivos móviles
- ✅ **Menú Lateral**: Colapsable con iconos modernos
- ✅ **Gráficos**: Visualización de datos con Chart.js

## Requisitos del Sistema

- PHP 7.4 o superior
- MySQL 5.7+ o MariaDB 10.2+
- Servidor web (Apache/Nginx)
- Extensiones PHP: PDO, PDO_MySQL

## Instalación

### 1. Configurar la Base de Datos

1. Crear una base de datos MySQL/MariaDB
2. Importar el archivo `database.sql`:
   ```sql
   mysql -u usuario -p nombre_base_datos < database.sql
   ```

### 2. Configurar la Aplicación

1. Editar el archivo `config.php` con los datos de tu base de datos:
   ```php
   define('DB_HOST', 'localhost');
   define('DB_NAME', 'crm_system');
   define('DB_USER', 'tu_usuario');
   define('DB_PASS', 'tu_contraseña');
   ```

### 3. Configurar el Servidor Web

1. Copiar todos los archivos al directorio web
2. Asegurar que el servidor tenga permisos de lectura
3. Configurar el documento raíz apuntando a la carpeta del proyecto

## Uso del Sistema

### Credenciales por Defecto

**Administrador:**
- Email: admin@crm.com
- Contraseña: admin123

**Usuario de Prueba:**
- Email: usuario@test.com
- Contraseña: usuario123

### Funcionalidades

#### Para Usuarios:
- Ver dashboard con estadísticas personales
- Gestionar contactos (crear, editar, eliminar)
- Ver estadísticas de contactos por mes y día

#### Para Administradores:
- Todas las funcionalidades de usuario
- Panel de administración con estadísticas globales
- Ver estadísticas por usuario
- Comparaciones y análisis de datos
- Gráficos de contactos por mes y usuario
- Ciudades más populares

## Estructura de Archivos

```
CRM2/
├── config.php          # Configuración de base de datos y funciones
├── database.sql        # Estructura de base de datos
├── login.php          # Página de inicio de sesión
├── register.php       # Página de registro
├── logout.php         # Cerrar sesión
├── dashboard.php      # Dashboard principal
├── contactos.php      # Gestión de contactos
├── admin.php          # Panel de administración
└── README.md          # Este archivo
```

## Campos de Contactos

- **Fecha**: Fecha de registro del contacto
- **Nombres y Apellidos**: Nombre completo
- **Celular**: Número de teléfono
- **Ciudad**: Ciudad de residencia

## Tecnologías Utilizadas

- **Backend**: PHP 7.4+
- **Base de Datos**: MySQL/MariaDB
- **Frontend**: HTML5, CSS3, JavaScript
- **Framework CSS**: Bootstrap 5.3
- **Iconos**: Font Awesome 6.4
- **Gráficos**: Chart.js
- **Responsive Design**: Mobile-first approach

## Características de Seguridad

- Contraseñas hasheadas con password_hash()
- Protección contra inyección SQL con PDO
- Validación y sanitización de datos
- Sesiones seguras
- Protección de rutas por roles

## Soporte

Desarrollado por **Vortex Agencia** ❤️

Para soporte técnico o consultas, contacta con el equipo de desarrollo.

## Licencia

Este proyecto es propiedad de Vortex Agencia. Todos los derechos reservados.