<?php
// Script de instalación automática del CRM
echo "<!DOCTYPE html>";
echo "<html lang='es'>";
echo "<head>";
echo "<meta charset='UTF-8'>";
echo "<meta name='viewport' content='width=device-width, initial-scale=1.0'>";
echo "<title>Instalación CRM - Configuración Automática</title>";
echo "<link href='https://cdn.jsdelivr.net/npm/bootstrap@5.1.3/dist/css/bootstrap.min.css' rel='stylesheet'>";
echo "<link href='https://cdnjs.cloudflare.com/ajax/libs/font-awesome/6.0.0/css/all.min.css' rel='stylesheet'>";
echo "</head>";
echo "<body class='bg-light'>";
echo "<div class='container mt-4'>";
echo "<div class='row justify-content-center'>";
echo "<div class='col-lg-8'>";

echo "<div class='card shadow'>";
echo "<div class='card-header bg-success text-white'>";
echo "<h2 class='mb-0'><i class='fas fa-cogs'></i> Instalación Automática CRM</h2>";
echo "</div>";
echo "<div class='card-body'>";

$errores = 0;
$pasos_completados = 0;

// Paso 1: Verificar extensión PDO
echo "<div class='mb-3'>";
echo "<h4><i class='fas fa-plug'></i> Paso 1: Verificando extensión PDO MySQL</h4>";
if (extension_loaded('pdo_mysql')) {
    echo "<div class='alert alert-success'><i class='fas fa-check'></i> Extensión PDO MySQL disponible</div>";
    $pasos_completados++;
} else {
    echo "<div class='alert alert-danger'><i class='fas fa-times'></i> Extensión PDO MySQL NO disponible</div>";
    $errores++;
}
echo "</div>";

if ($errores > 0) {
    echo "<div class='alert alert-danger'><strong>No se puede continuar. Instale la extensión PDO MySQL.</strong></div>";
    echo "</div></div></div></div></body></html>";
    exit;
}

// Paso 2: Cargar configuración
echo "<div class='mb-3'>";
echo "<h4><i class='fas fa-cog'></i> Paso 2: Cargando configuración</h4>";
try {
    require_once 'config.php';
    echo "<div class='alert alert-success'><i class='fas fa-check'></i> Configuración cargada correctamente</div>";
    echo "<p><strong>Host:</strong> " . DB_HOST . " | <strong>Base de datos:</strong> " . DB_NAME . " | <strong>Usuario:</strong> " . DB_USER . "</p>";
    $pasos_completados++;
} catch (Exception $e) {
    echo "<div class='alert alert-danger'><i class='fas fa-times'></i> Error cargando configuración: " . $e->getMessage() . "</div>";
    $errores++;
}
echo "</div>";

if ($errores > 0) {
    echo "<div class='alert alert-danger'><strong>No se puede continuar. Verifique config.php.</strong></div>";
    echo "</div></div></div></div></body></html>";
    exit;
}

// Paso 3: Conectar al servidor MySQL (sin especificar base de datos)
echo "<div class='mb-3'>";
echo "<h4><i class='fas fa-server'></i> Paso 3: Conectando al servidor MySQL</h4>";
try {
    $dsn = "mysql:host=" . DB_HOST . ";charset=" . DB_CHARSET;
    $pdo = new PDO($dsn, DB_USER, DB_PASS, [
        PDO::ATTR_ERRMODE => PDO::ERRMODE_EXCEPTION,
        PDO::ATTR_DEFAULT_FETCH_MODE => PDO::FETCH_ASSOC
    ]);
    echo "<div class='alert alert-success'><i class='fas fa-check'></i> Conexión al servidor MySQL exitosa</div>";
    $pasos_completados++;
} catch (Exception $e) {
    echo "<div class='alert alert-danger'><i class='fas fa-times'></i> Error conectando al servidor: " . $e->getMessage() . "</div>";
    echo "<div class='alert alert-info'><strong>Verifique:</strong> Credenciales, servidor MySQL ejecutándose, permisos de usuario</div>";
    $errores++;
}
echo "</div>";

if ($errores > 0) {
    echo "<div class='alert alert-danger'><strong>No se puede continuar. Verifique la conexión MySQL.</strong></div>";
    echo "</div></div></div></div></body></html>";
    exit;
}

// Paso 4: Crear base de datos si no existe
echo "<div class='mb-3'>";
echo "<h4><i class='fas fa-database'></i> Paso 4: Creando/verificando base de datos</h4>";
try {
    $pdo->exec("CREATE DATABASE IF NOT EXISTS `" . DB_NAME . "` CHARACTER SET utf8mb4 COLLATE utf8mb4_unicode_ci");
    echo "<div class='alert alert-success'><i class='fas fa-check'></i> Base de datos '" . DB_NAME . "' creada/verificada</div>";
    
    // Seleccionar la base de datos
    $pdo->exec("USE `" . DB_NAME . "`");
    echo "<div class='alert alert-info'><i class='fas fa-info-circle'></i> Usando base de datos '" . DB_NAME . "'</div>";
    $pasos_completados++;
} catch (Exception $e) {
    echo "<div class='alert alert-danger'><i class='fas fa-times'></i> Error creando base de datos: " . $e->getMessage() . "</div>";
    $errores++;
}
echo "</div>";

if ($errores > 0) {
    echo "<div class='alert alert-danger'><strong>No se puede continuar. Error creando base de datos.</strong></div>";
    echo "</div></div></div></div></body></html>";
    exit;
}

// Paso 5: Ejecutar script SQL
echo "<div class='mb-3'>";
echo "<h4><i class='fas fa-file-code'></i> Paso 5: Ejecutando script de base de datos</h4>";

if (!file_exists('database.sql')) {
    echo "<div class='alert alert-danger'><i class='fas fa-times'></i> Archivo database.sql no encontrado</div>";
    $errores++;
} else {
    try {
        $sql_content = file_get_contents('database.sql');
        
        // Dividir el contenido en declaraciones individuales
        $statements = array_filter(array_map('trim', explode(';', $sql_content)));
        
        $ejecutadas = 0;
        $errores_sql = 0;
        
        echo "<div class='progress mb-3'>";
        echo "<div class='progress-bar' role='progressbar' style='width: 0%' id='progress-bar'></div>";
        echo "</div>";
        echo "<div id='sql-log' style='max-height: 200px; overflow-y: auto; background: #f8f9fa; padding: 10px; border-radius: 5px;'>";
        
        foreach ($statements as $index => $statement) {
            if (empty($statement) || strpos(trim($statement), '--') === 0) {
                continue;
            }
            
            try {
                $pdo->exec($statement);
                $ejecutadas++;
                echo "<small class='text-success'><i class='fas fa-check'></i> Declaración " . ($index + 1) . " ejecutada</small><br>";
            } catch (Exception $e) {
                $errores_sql++;
                echo "<small class='text-warning'><i class='fas fa-exclamation-triangle'></i> Declaración " . ($index + 1) . ": " . $e->getMessage() . "</small><br>";
            }
            
            // Actualizar barra de progreso
            $progreso = (($index + 1) / count($statements)) * 100;
            echo "<script>document.getElementById('progress-bar').style.width = '" . $progreso . "%';</script>";
            flush();
        }
        
        echo "</div>";
        
        if ($errores_sql == 0) {
            echo "<div class='alert alert-success'><i class='fas fa-check'></i> Script SQL ejecutado completamente ($ejecutadas declaraciones)</div>";
            $pasos_completados++;
        } else {
            echo "<div class='alert alert-warning'><i class='fas fa-exclamation-triangle'></i> Script ejecutado con $errores_sql advertencias ($ejecutadas declaraciones exitosas)</div>";
            $pasos_completados++;
        }
        
    } catch (Exception $e) {
        echo "<div class='alert alert-danger'><i class='fas fa-times'></i> Error ejecutando script SQL: " . $e->getMessage() . "</div>";
        $errores++;
    }
}
echo "</div>";

// Paso 6: Verificar instalación
echo "<div class='mb-3'>";
echo "<h4><i class='fas fa-check-double'></i> Paso 6: Verificando instalación</h4>";

if ($errores == 0) {
    try {
        // Verificar tablas principales
        $tablas = ['usuarios', 'contactos'];
        $tablas_ok = 0;
        
        foreach ($tablas as $tabla) {
            $stmt = $pdo->query("SHOW TABLES LIKE '$tabla'");
            if ($stmt->rowCount() > 0) {
                $tablas_ok++;
                echo "<div class='alert alert-success py-2'><i class='fas fa-check'></i> Tabla '$tabla' creada correctamente</div>";
            } else {
                echo "<div class='alert alert-danger py-2'><i class='fas fa-times'></i> Tabla '$tabla' no encontrada</div>";
            }
        }
        
        // Verificar datos de ejemplo
        $stmt = $pdo->query("SELECT COUNT(*) FROM usuarios");
        $usuarios_count = $stmt->fetchColumn();
        
        $stmt = $pdo->query("SELECT COUNT(*) FROM contactos");
        $contactos_count = $stmt->fetchColumn();
        
        echo "<div class='alert alert-info'>";
        echo "<i class='fas fa-info-circle'></i> Datos creados: $usuarios_count usuarios, $contactos_count contactos";
        echo "</div>";
        
        if ($tablas_ok == count($tablas)) {
            $pasos_completados++;
        }
        
    } catch (Exception $e) {
        echo "<div class='alert alert-danger'><i class='fas fa-times'></i> Error verificando instalación: " . $e->getMessage() . "</div>";
    }
}
echo "</div>";

// Resumen final
echo "<div class='mb-4'>";
echo "<h4><i class='fas fa-clipboard-check'></i> Resumen de Instalación</h4>";

if ($pasos_completados >= 5 && $errores == 0) {
    echo "<div class='alert alert-success'>";
    echo "<h5><i class='fas fa-check-circle'></i> ¡Instalación Completada Exitosamente!</h5>";
    echo "<p>El sistema CRM ha sido instalado y configurado correctamente.</p>";
    echo "<p><strong>Pasos completados:</strong> $pasos_completados/6</p>";
    echo "</div>";
    
    echo "<div class='alert alert-info'>";
    echo "<h6>Credenciales de acceso por defecto:</h6>";
    echo "<p><strong>Usuario:</strong> admin<br><strong>Contraseña:</strong> admin123</p>";
    echo "<p><em>Recuerde cambiar estas credenciales después del primer acceso.</em></p>";
    echo "</div>";
    
} else {
    echo "<div class='alert alert-warning'>";
    echo "<h5><i class='fas fa-exclamation-triangle'></i> Instalación Incompleta</h5>";
    echo "<p>La instalación se completó parcialmente con algunos problemas.</p>";
    echo "<p><strong>Pasos completados:</strong> $pasos_completados/6 | <strong>Errores:</strong> $errores</p>";
    echo "</div>";
}
echo "</div>";

// Enlaces de navegación
echo "<div class='text-center'>";
if ($pasos_completados >= 4) {
    echo "<a href='login.php' class='btn btn-primary me-2'><i class='fas fa-sign-in-alt'></i> Ir al Login</a>";
    echo "<a href='test_connection.php' class='btn btn-secondary me-2'><i class='fas fa-stethoscope'></i> Diagnóstico</a>";
}
echo "<a href='install.php' class='btn btn-outline-primary'><i class='fas fa-redo'></i> Reinstalar</a>";
echo "</div>";

echo "</div>";
echo "</div>";
echo "</div>";
echo "</div>";
echo "</div>";

echo "<script>";
echo "// Auto-scroll del log";
echo "const logDiv = document.getElementById('sql-log');";
echo "if (logDiv) logDiv.scrollTop = logDiv.scrollHeight;";
echo "</script>";

echo "</body>";
echo "</html>";
?>