<?php
// Habilitar reporte de errores
error_reporting(E_ALL);
ini_set('display_errors', 1);
ini_set('log_errors', 1);

echo "<h1>🔍 Diagnóstico del Sistema CRM</h1>";
echo "<style>body{font-family:Arial,sans-serif;margin:20px;} .ok{color:green;} .error{color:red;} .warning{color:orange;} pre{background:#f5f5f5;padding:10px;border-radius:5px;}</style>";

echo "<h2>1. Verificación de Archivos</h2>";

// Verificar archivos principales
$archivos = [
    'config.php' => 'Configuración de base de datos',
    'contactos.php' => 'Página de contactos original',
    'contactos_safe.php' => 'Página de contactos segura',
    'database.sql' => 'Script de base de datos',
    'migrate_database.php' => 'Script de migración'
];

foreach ($archivos as $archivo => $descripcion) {
    if (file_exists($archivo)) {
        echo "<p class='ok'>✅ $archivo - $descripcion (" . number_format(filesize($archivo)) . " bytes)</p>";
    } else {
        echo "<p class='error'>❌ $archivo - $descripcion (NO ENCONTRADO)</p>";
    }
}

echo "<h2>2. Verificación de Configuración PHP</h2>";
echo "<p>Versión PHP: <strong>" . phpversion() . "</strong></p>";
echo "<p>Extensiones requeridas:</p>";

$extensiones = ['pdo', 'pdo_mysql', 'mysqli'];
foreach ($extensiones as $ext) {
    if (extension_loaded($ext)) {
        echo "<p class='ok'>✅ $ext</p>";
    } else {
        echo "<p class='error'>❌ $ext (NO DISPONIBLE)</p>";
    }
}

echo "<h2>3. Verificación de Conexión a Base de Datos</h2>";

try {
    if (file_exists('config.php')) {
        require_once 'config.php';
        echo "<p class='ok'>✅ config.php cargado correctamente</p>";
        
        if (class_exists('Database')) {
            echo "<p class='ok'>✅ Clase Database encontrada</p>";
            
            $database = new Database();
            $db = $database->getConnection();
            
            if ($db) {
                echo "<p class='ok'>✅ Conexión a base de datos exitosa</p>";
                
                // Verificar tablas existentes
                echo "<h3>Tablas en la base de datos:</h3>";
                $tables = $db->query("SHOW TABLES")->fetchAll(PDO::FETCH_COLUMN);
                foreach ($tables as $table) {
                    echo "<p class='ok'>📋 $table</p>";
                }
                
                // Verificar estructura de tabla contactos
                echo "<h3>Estructura de tabla 'contactos':</h3>";
                try {
                    $columns = $db->query("SHOW COLUMNS FROM contactos")->fetchAll();
                    echo "<pre>";
                    foreach ($columns as $column) {
                        echo "- {$column['Field']} ({$column['Type']})\n";
                    }
                    echo "</pre>";
                } catch (Exception $e) {
                    echo "<p class='error'>❌ Error al obtener estructura: " . $e->getMessage() . "</p>";
                }
                
            } else {
                echo "<p class='error'>❌ No se pudo conectar a la base de datos</p>";
            }
        } else {
            echo "<p class='error'>❌ Clase Database no encontrada</p>";
        }
    } else {
        echo "<p class='error'>❌ config.php no encontrado</p>";
    }
} catch (Exception $e) {
    echo "<p class='error'>❌ Error: " . $e->getMessage() . "</p>";
    echo "<pre>" . $e->getTraceAsString() . "</pre>";
}

echo "<h2>4. Verificación de Sesiones</h2>";

try {
    if (session_status() == PHP_SESSION_NONE) {
        session_start();
    }
    echo "<p class='ok'>✅ Sesiones funcionando</p>";
    
    if (isset($_SESSION['user_id'])) {
        echo "<p class='ok'>✅ Usuario logueado (ID: {$_SESSION['user_id']})</p>";
    } else {
        echo "<p class='warning'>⚠️ No hay usuario logueado</p>";
    }
} catch (Exception $e) {
    echo "<p class='error'>❌ Error con sesiones: " . $e->getMessage() . "</p>";
}

echo "<h2>5. Prueba de Carga de contactos.php</h2>";

try {
    ob_start();
    $error_occurred = false;
    
    // Capturar errores
    set_error_handler(function($severity, $message, $file, $line) use (&$error_occurred) {
        $error_occurred = true;
        echo "<p class='error'>❌ Error PHP: $message en $file línea $line</p>";
    });
    
    // Intentar incluir contactos.php
    if (file_exists('contactos.php')) {
        // Simular variables de sesión si no existen
        if (!isset($_SESSION['user_id'])) {
            $_SESSION['user_id'] = 1;
            $_SESSION['user_name'] = 'Test User';
        }
        
        include 'contactos.php';
        
        if (!$error_occurred) {
            echo "<p class='ok'>✅ contactos.php se carga sin errores PHP</p>";
        }
    } else {
        echo "<p class='error'>❌ contactos.php no encontrado</p>";
    }
    
    restore_error_handler();
    $output = ob_get_clean();
    
} catch (ParseError $e) {
    echo "<p class='error'>❌ Error de sintaxis en contactos.php: " . $e->getMessage() . "</p>";
    echo "<p>Línea: " . $e->getLine() . "</p>";
} catch (Error $e) {
    echo "<p class='error'>❌ Error fatal en contactos.php: " . $e->getMessage() . "</p>";
    echo "<p>Línea: " . $e->getLine() . "</p>";
} catch (Exception $e) {
    echo "<p class='error'>❌ Excepción en contactos.php: " . $e->getMessage() . "</p>";
    echo "<p>Línea: " . $e->getLine() . "</p>";
}

echo "<h2>6. Recomendaciones</h2>";
echo "<div style='background:#e7f3ff;padding:15px;border-radius:5px;'>";
echo "<h3>🔧 Pasos para solucionar:</h3>";
echo "<ol>";
echo "<li><strong>Si hay errores de base de datos:</strong> Ejecuta <a href='migrate_database.php' target='_blank'>migrate_database.php</a></li>";
echo "<li><strong>Si contactos.php falla:</strong> Usa <a href='contactos_safe.php'>contactos_safe.php</a> temporalmente</li>";
echo "<li><strong>Si hay errores de sintaxis:</strong> Revisa el código PHP en las líneas indicadas</li>";
echo "<li><strong>Si no hay usuario logueado:</strong> Ve a <a href='login.php'>login.php</a> primero</li>";
echo "</ol>";
echo "</div>";

echo "<h2>7. Enlaces Útiles</h2>";
echo "<p>";
echo "<a href='migrate_database.php' style='background:#007bff;color:white;padding:10px;text-decoration:none;border-radius:5px;margin:5px;'>🔄 Migrar Base de Datos</a> ";
echo "<a href='contactos_safe.php' style='background:#28a745;color:white;padding:10px;text-decoration:none;border-radius:5px;margin:5px;'>📋 Contactos Seguro</a> ";
echo "<a href='contactos.php' style='background:#dc3545;color:white;padding:10px;text-decoration:none;border-radius:5px;margin:5px;'>📋 Contactos Original</a> ";
echo "<a href='dashboard.php' style='background:#6c757d;color:white;padding:10px;text-decoration:none;border-radius:5px;margin:5px;'>📊 Dashboard</a>";
echo "</p>";

echo "<hr><p style='text-align:center;color:#666;'>Diagnóstico completado - " . date('Y-m-d H:i:s') . "</p>";
?>