<?php
// Prueba simple de configuración y conexión
echo "<!DOCTYPE html>";
echo "<html lang='es'>";
echo "<head>";
echo "<meta charset='UTF-8'>";
echo "<title>Prueba Simple CRM</title>";
echo "<link href='https://cdn.jsdelivr.net/npm/bootstrap@5.1.3/dist/css/bootstrap.min.css' rel='stylesheet'>";
echo "</head>";
echo "<body class='bg-light'>";
echo "<div class='container mt-4'>";
echo "<div class='card'>";
echo "<div class='card-header bg-info text-white'>";
echo "<h3>Prueba Simple de Configuración CRM</h3>";
echo "</div>";
echo "<div class='card-body'>";

$pasos = [];
$errores = [];

// Paso 1: Verificar PHP
echo "<h5>1. Verificando PHP</h5>";
echo "<p>Versión PHP: " . phpversion() . "</p>";
if (version_compare(phpversion(), '7.4.0', '>=')) {
    echo "<div class='alert alert-success'>✓ Versión PHP compatible</div>";
    $pasos[] = 'PHP OK';
} else {
    echo "<div class='alert alert-warning'>⚠ Versión PHP antigua (recomendado 7.4+)</div>";
    $errores[] = 'PHP version';
}

// Paso 2: Verificar extensiones
echo "<h5>2. Verificando extensiones</h5>";
if (extension_loaded('pdo_mysql')) {
    echo "<div class='alert alert-success'>✓ PDO MySQL disponible</div>";
    $pasos[] = 'PDO OK';
} else {
    echo "<div class='alert alert-danger'>✗ PDO MySQL NO disponible</div>";
    $errores[] = 'PDO MySQL';
}

// Paso 3: Verificar config.php
echo "<h5>3. Verificando config.php</h5>";
if (file_exists('config.php')) {
    echo "<div class='alert alert-success'>✓ Archivo config.php existe</div>";
    
    try {
        require_once 'config.php';
        echo "<div class='alert alert-success'>✓ Config.php cargado correctamente</div>";
        $pasos[] = 'Config loaded';
        
        // Verificar constantes
        $constantes_requeridas = ['DB_HOST', 'DB_NAME', 'DB_USER', 'DB_PASS'];
        $constantes_ok = true;
        
        foreach ($constantes_requeridas as $constante) {
            if (defined($constante)) {
                echo "<p>✓ $constante: " . (($constante === 'DB_PASS') ? '***' : constant($constante)) . "</p>";
            } else {
                echo "<p class='text-danger'>✗ $constante: NO DEFINIDA</p>";
                $constantes_ok = false;
            }
        }
        
        if ($constantes_ok) {
            $pasos[] = 'Constants OK';
        } else {
            $errores[] = 'Missing constants';
        }
        
    } catch (Exception $e) {
        echo "<div class='alert alert-danger'>✗ Error cargando config.php: " . $e->getMessage() . "</div>";
        $errores[] = 'Config error: ' . $e->getMessage();
    }
} else {
    echo "<div class='alert alert-danger'>✗ Archivo config.php NO existe</div>";
    $errores[] = 'Config file missing';
}

// Paso 4: Verificar clase Database
echo "<h5>4. Verificando clase Database</h5>";
if (class_exists('Database')) {
    echo "<div class='alert alert-success'>✓ Clase Database disponible</div>";
    $pasos[] = 'Database class OK';
    
    try {
        $database = new Database();
        echo "<div class='alert alert-success'>✓ Instancia Database creada</div>";
        $pasos[] = 'Database instance OK';
        
        $db = $database->getConnection();
        if ($db) {
            echo "<div class='alert alert-success'>✓ Conexión a base de datos exitosa</div>";
            $pasos[] = 'DB connection OK';
            
            // Probar consulta simple
            try {
                $version = $db->query('SELECT VERSION()')->fetchColumn();
                echo "<p>Versión MySQL/MariaDB: $version</p>";
                $pasos[] = 'DB query OK';
            } catch (Exception $e) {
                echo "<div class='alert alert-warning'>⚠ Error en consulta de prueba: " . $e->getMessage() . "</div>";
                $errores[] = 'DB query error';
            }
        } else {
            echo "<div class='alert alert-danger'>✗ No se pudo conectar a la base de datos</div>";
            $errores[] = 'DB connection failed';
        }
    } catch (Exception $e) {
        echo "<div class='alert alert-danger'>✗ Error con clase Database: " . $e->getMessage() . "</div>";
        $errores[] = 'Database class error: ' . $e->getMessage();
    }
} else {
    echo "<div class='alert alert-danger'>✗ Clase Database NO disponible</div>";
    $errores[] = 'Database class missing';
}

// Paso 5: Verificar funciones de sesión
echo "<h5>5. Verificando funciones de sesión</h5>";
if (function_exists('isLoggedIn')) {
    echo "<div class='alert alert-success'>✓ Función isLoggedIn disponible</div>";
    $pasos[] = 'Session functions OK';
} else {
    echo "<div class='alert alert-danger'>✗ Función isLoggedIn NO disponible</div>";
    $errores[] = 'Session functions missing';
}

// Resumen
echo "<hr>";
echo "<h5>Resumen</h5>";
echo "<p><strong>Pasos exitosos:</strong> " . count($pasos) . "</p>";
echo "<p><strong>Errores encontrados:</strong> " . count($errores) . "</p>";

if (count($errores) == 0) {
    echo "<div class='alert alert-success'><h6>¡Configuración Perfecta!</h6>";
    echo "<p>Todos los componentes están funcionando correctamente.</p>";
    echo "<a href='contactos.php' class='btn btn-primary'>Probar Contactos</a>";
    echo "</div>";
} elseif (count($errores) <= 2) {
    echo "<div class='alert alert-warning'><h6>Configuración Funcional</h6>";
    echo "<p>Hay algunos problemas menores, pero debería funcionar.</p>";
    echo "<a href='contactos.php' class='btn btn-warning'>Probar Contactos</a>";
    echo "</div>";
} else {
    echo "<div class='alert alert-danger'><h6>Configuración con Problemas</h6>";
    echo "<p>Se encontraron varios errores que deben resolverse.</p>";
    echo "<a href='install.php' class='btn btn-danger'>Ejecutar Instalación</a>";
    echo "</div>";
}

echo "<div class='mt-3'>";
echo "<a href='test_connection.php' class='btn btn-info me-2'>Diagnóstico Completo</a>";
echo "<a href='install.php' class='btn btn-success me-2'>Instalación</a>";
echo "<a href='login.php' class='btn btn-secondary'>Login</a>";
echo "</div>";

echo "</div>";
echo "</div>";
echo "</div>";
echo "</body>";
echo "</html>";
?>