<?php
// Test de conexión y verificación de tabla etiquetas
require_once 'config.php';

echo "<h2>🔍 Diagnóstico de Etiquetas</h2>";

try {
    // Crear conexión
    $database = new Database();
    $db = $database->getConnection();
    
    if ($db) {
        echo "<p>✅ <strong>Conexión a la base de datos:</strong> EXITOSA</p>";
        echo "<p>📊 <strong>Base de datos:</strong> " . DB_NAME . "</p>";
        echo "<p>🖥️ <strong>Servidor:</strong> " . DB_HOST . "</p>";
        
        // Verificar si la tabla etiquetas existe
        $query_table = "SHOW TABLES LIKE 'etiquetas'";
        $stmt_table = $db->prepare($query_table);
        $stmt_table->execute();
        $table_exists = $stmt_table->fetch();
        
        if ($table_exists) {
            echo "<p>✅ <strong>Tabla 'etiquetas':</strong> EXISTE</p>";
            
            // Verificar estructura de la tabla
            $query_structure = "DESCRIBE etiquetas";
            $stmt_structure = $db->prepare($query_structure);
            $stmt_structure->execute();
            $columns = $stmt_structure->fetchAll();
            
            echo "<h3>📋 Estructura de la tabla:</h3>";
            echo "<table border='1' style='border-collapse: collapse; width: 100%;'>";
            echo "<tr><th>Campo</th><th>Tipo</th><th>Nulo</th><th>Clave</th><th>Por defecto</th></tr>";
            foreach ($columns as $column) {
                echo "<tr>";
                echo "<td>" . $column['Field'] . "</td>";
                echo "<td>" . $column['Type'] . "</td>";
                echo "<td>" . $column['Null'] . "</td>";
                echo "<td>" . $column['Key'] . "</td>";
                echo "<td>" . $column['Default'] . "</td>";
                echo "</tr>";
            }
            echo "</table>";
            
            // Contar etiquetas
            $query_count = "SELECT COUNT(*) as total FROM etiquetas";
            $stmt_count = $db->prepare($query_count);
            $stmt_count->execute();
            $count = $stmt_count->fetch();
            
            echo "<p>📊 <strong>Total de etiquetas:</strong> " . $count['total'] . "</p>";
            
            if ($count['total'] > 0) {
                // Mostrar etiquetas existentes
                $query_etiquetas = "SELECT * FROM etiquetas ORDER BY nombre";
                $stmt_etiquetas = $db->prepare($query_etiquetas);
                $stmt_etiquetas->execute();
                $etiquetas = $stmt_etiquetas->fetchAll();
                
                echo "<h3>🏷️ Etiquetas existentes:</h3>";
                echo "<table border='1' style='border-collapse: collapse; width: 100%;'>";
                echo "<tr><th>ID</th><th>Nombre</th><th>Color</th><th>Fecha Creación</th></tr>";
                foreach ($etiquetas as $etiqueta) {
                    echo "<tr>";
                    echo "<td>" . $etiqueta['id'] . "</td>";
                    echo "<td>" . $etiqueta['nombre'] . "</td>";
                    echo "<td style='background-color: " . $etiqueta['color'] . "; color: white;'>" . $etiqueta['color'] . "</td>";
                    echo "<td>" . $etiqueta['fecha_creacion'] . "</td>";
                    echo "</tr>";
                }
                echo "</table>";
            } else {
                echo "<p>⚠️ <strong>No hay etiquetas en la base de datos</strong></p>";
                echo "<p>💡 <strong>Sugerencia:</strong> Ejecuta el archivo database.sql para insertar etiquetas de ejemplo</p>";
            }
            
        } else {
            echo "<p>❌ <strong>Tabla 'etiquetas':</strong> NO EXISTE</p>";
            echo "<p>💡 <strong>Solución:</strong> Ejecuta el archivo database.sql para crear la tabla</p>";
        }
        
        // Probar la consulta AJAX
        echo "<h3>🧪 Prueba de consulta AJAX:</h3>";
        $query_ajax = "SELECT * FROM etiquetas ORDER BY nombre";
        $stmt_ajax = $db->prepare($query_ajax);
        $stmt_ajax->execute();
        $etiquetas_ajax = $stmt_ajax->fetchAll();
        
        $response = ['success' => true, 'etiquetas' => $etiquetas_ajax];
        echo "<pre>" . json_encode($response, JSON_PRETTY_PRINT | JSON_UNESCAPED_UNICODE) . "</pre>";
        
    } else {
        echo "<p>❌ <strong>Error:</strong> No se pudo conectar a la base de datos</p>";
    }
    
} catch (Exception $e) {
    echo "<p>❌ <strong>Error:</strong> " . $e->getMessage() . "</p>";
}

echo "<hr>";
echo "<p><a href='admin.php'>← Volver a Admin</a></p>";
?>