<?php
// Script para configurar la base de datos remota
error_reporting(E_ALL);
ini_set('display_errors', 1);

echo "<h2>Configuración de Base de Datos Remota</h2>";
echo "<p><strong>Base de datos:</strong> v34sdfaas213_crmlead</p>";

try {
    // Usar las credenciales del config.php
    require_once 'config.php';
    
    $pdo = new PDO("mysql:host=" . DB_HOST . ";dbname=" . DB_NAME . ";charset=" . DB_CHARSET, DB_USER, DB_PASS);
    $pdo->setAttribute(PDO::ATTR_ERRMODE, PDO::ERRMODE_EXCEPTION);
    echo "<p style='color: green;'>✅ Conexión a la base de datos remota exitosa</p>";
    
    // Leer y ejecutar el archivo SQL
    $sql = file_get_contents('database.sql');
    
    if (!$sql) {
        throw new Exception("No se pudo leer el archivo database.sql");
    }
    
    echo "<p>📄 Archivo database.sql leído correctamente</p>";
    
    // Dividir en consultas individuales
    $queries = explode(';', $sql);
    $executedQueries = 0;
    $errors = [];
    
    foreach ($queries as $query) {
        $query = trim($query);
        if (!empty($query) && !str_starts_with($query, '--') && !str_starts_with($query, 'SELECT')) {
            try {
                $pdo->exec($query);
                $executedQueries++;
            } catch (PDOException $e) {
                // Ignorar algunos errores esperados
                if (str_contains($e->getMessage(), "doesn't exist") || 
                    str_contains($e->getMessage(), "Duplicate entry") ||
                    str_contains($e->getMessage(), "already exists")) {
                    // Estos errores son esperados y no críticos
                    continue;
                } else {
                    $errors[] = "Error en consulta: " . substr($query, 0, 50) . "... - " . $e->getMessage();
                }
            }
        }
    }
    
    echo "<p style='color: green;'>✅ Consultas ejecutadas: $executedQueries</p>";
    
    if (!empty($errors)) {
        echo "<h3 style='color: orange;'>⚠️ Errores encontrados (pueden ser normales):</h3>";
        foreach ($errors as $error) {
            echo "<p style='color: orange; font-size: 12px;'>$error</p>";
        }
    }
    
    // Verificar que las tablas se crearon
    echo "<h3>📋 Verificando estructura de la base de datos:</h3>";
    
    $tables = ['usuarios', 'contactos', 'etiquetas', 'contacto_etiquetas', 'historial_cambios'];
    $allTablesExist = true;
    
    foreach ($tables as $table) {
        $stmt = $pdo->query("SHOW TABLES LIKE '$table'");
        if ($stmt->rowCount() > 0) {
            echo "<p style='color: green;'>✅ Tabla '$table' existe</p>";
            
            // Contar registros
            $countStmt = $pdo->query("SELECT COUNT(*) as total FROM $table");
            $count = $countStmt->fetch(PDO::FETCH_ASSOC)['total'];
            echo "<p style='margin-left: 20px; color: blue;'>📊 Registros: $count</p>";
        } else {
            echo "<p style='color: red;'>❌ Tabla '$table' NO existe</p>";
            $allTablesExist = false;
        }
    }
    
    if ($allTablesExist) {
        echo "<h3 style='color: green;'>🎉 ¡Base de datos configurada correctamente!</h3>";
        
        // Mostrar usuarios disponibles
        echo "<h4>👥 Usuarios disponibles para login:</h4>";
        $stmt = $pdo->query("SELECT username, email, tipo FROM usuarios WHERE activo = 1");
        $users = $stmt->fetchAll(PDO::FETCH_ASSOC);
        
        echo "<ul>";
        foreach ($users as $user) {
            echo "<li><strong>{$user['username']}</strong> ({$user['email']}) - {$user['tipo']}</li>";
        }
        echo "</ul>";
        
        echo "<p style='color: blue;'>💡 <strong>Contraseña por defecto para todos los usuarios:</strong> password</p>";
        echo "<p><a href='login.php' style='background: #dc2626; color: white; padding: 10px 20px; text-decoration: none; border-radius: 5px;'>Ir al Login</a></p>";
    } else {
        echo "<p style='color: red;'>❌ Algunas tablas no se crearon correctamente. Revisa los errores arriba.</p>";
    }
    
} catch(PDOException $e) {
    echo "<p style='color: red;'>❌ Error de conexión: " . $e->getMessage() . "</p>";
    echo "<h3>Posibles soluciones:</h3>";
    echo "<ul>";
    echo "<li>Verificar que las credenciales en config.php sean correctas</li>";
    echo "<li>Confirmar que la base de datos 'v34sdfaas213_crmlead' existe en el servidor</li>";
    echo "<li>Verificar que el usuario tenga permisos para crear tablas</li>";
    echo "<li>Comprobar la conectividad con el servidor de base de datos</li>";
    echo "</ul>";
} catch(Exception $e) {
    echo "<p style='color: red;'>❌ Error general: " . $e->getMessage() . "</p>";
}
?>