<?php
// Script para configurar la base de datos local
error_reporting(E_ALL);
ini_set('display_errors', 1);

echo "<h2>Configuración de Base de Datos Local</h2>";

try {
    // Conectar a MySQL sin especificar base de datos
    $pdo = new PDO('mysql:host=localhost;charset=utf8mb4', 'root', '');
    $pdo->setAttribute(PDO::ATTR_ERRMODE, PDO::ERRMODE_EXCEPTION);
    echo "<p style='color: green;'>✅ Conexión a MySQL exitosa</p>";
    
    // Crear base de datos
    $pdo->exec("CREATE DATABASE IF NOT EXISTS crm_system CHARACTER SET utf8mb4 COLLATE utf8mb4_unicode_ci");
    echo "<p style='color: green;'>✅ Base de datos 'crm_system' creada</p>";
    
    // Usar la base de datos
    $pdo->exec("USE crm_system");
    
    // Leer y ejecutar el archivo SQL
    $sql = file_get_contents('database.sql');
    
    // Dividir en consultas individuales
    $queries = explode(';', $sql);
    
    foreach ($queries as $query) {
        $query = trim($query);
        if (!empty($query) && !str_starts_with($query, '--')) {
            try {
                $pdo->exec($query);
            } catch (PDOException $e) {
                // Ignorar errores de DROP TABLE si no existe
                if (!str_contains($e->getMessage(), "doesn't exist")) {
                    throw $e;
                }
            }
        }
    }
    
    echo "<p style='color: green;'>✅ Tablas creadas correctamente</p>";
    
    // Insertar usuarios de prueba
    $stmt = $pdo->prepare("INSERT INTO usuarios (username, email, password, tipo) VALUES (?, ?, ?, ?)");
    
    // Admin
    $adminPassword = password_hash('admin123', PASSWORD_DEFAULT);
    $stmt->execute(['admin', 'admin@crm.com', $adminPassword, 'administrador']);
    
    // Usuario normal
    $userPassword = password_hash('user123', PASSWORD_DEFAULT);
    $stmt->execute(['usuario', 'usuario@crm.com', $userPassword, 'usuario']);
    
    echo "<p style='color: green;'>✅ Usuarios de prueba creados:</p>";
    echo "<ul>";
    echo "<li><strong>Admin:</strong> admin@crm.com / admin123</li>";
    echo "<li><strong>Usuario:</strong> usuario@crm.com / user123</li>";
    echo "</ul>";
    
    echo "<p style='color: blue;'>🎉 <strong>Base de datos configurada correctamente!</strong></p>";
    echo "<p><a href='login.php' style='background: #dc2626; color: white; padding: 10px 20px; text-decoration: none; border-radius: 5px;'>Ir al Login</a></p>";
    
} catch(PDOException $e) {
    echo "<p style='color: red;'>❌ Error: " . $e->getMessage() . "</p>";
}
?>