# 🚀 Guía de Instalación CRM System

## ❌ Problema Identificado

El error HTTP 500 en `contactos.php` se debe a que **PHP no está instalado** en el sistema Windows.

## 📋 Requisitos del Sistema

- Windows 10/11
- PHP 7.4 o superior
- MySQL/MariaDB
- Servidor web (Apache/Nginx) o PHP Built-in Server

## 🔧 Instalación Paso a Paso

### Opción 1: XAMPP (Recomendado para desarrollo)

1. **Descargar XAMPP**
   - Ir a: https://www.apachefriends.org/download.html
   - Descargar la versión para Windows
   - Ejecutar el instalador como administrador

2. **Configurar XAMPP**
   - Instalar en `C:\xampp`
   - Iniciar Apache y MySQL desde el panel de control
   - Verificar que funciona visitando: http://localhost

3. **Configurar el proyecto**
   - Copiar la carpeta `CRM2` a `C:\xampp\htdocs\`
   - Acceder via: http://localhost/CRM2/

### Opción 2: PHP Standalone

1. **Descargar PHP**
   - Ir a: https://windows.php.net/download/
   - Descargar "Thread Safe" ZIP
   - Extraer a `C:\php`

2. **Configurar PATH**
   - Abrir "Variables de entorno del sistema"
   - Agregar `C:\php` al PATH
   - Reiniciar PowerShell/CMD

3. **Configurar PHP**
   - Copiar `php.ini-development` a `php.ini`
   - Habilitar extensiones necesarias:
     ```ini
     extension=pdo_mysql
     extension=mysqli
     extension=mbstring
     extension=openssl
     ```

4. **Instalar MySQL**
   - Descargar MySQL Community Server
   - O usar MySQL Workbench
   - Configurar usuario y contraseña

## 🗄️ Configuración de Base de Datos

### Crear Base de Datos

```sql
CREATE DATABASE crm_system CHARACTER SET utf8mb4 COLLATE utf8mb4_unicode_ci;
CREATE USER 'crm_user'@'localhost' IDENTIFIED BY 'crm_password';
GRANT ALL PRIVILEGES ON crm_system.* TO 'crm_user'@'localhost';
FLUSH PRIVILEGES;
```

### Configurar config.php

Editar el archivo `config.php` con los datos correctos:

```php
// Configuración de la base de datos
define('DB_HOST', 'localhost');
define('DB_NAME', 'crm_system');
define('DB_USER', 'crm_user');
define('DB_PASS', 'crm_password');
define('DB_CHARSET', 'utf8mb4');
```

## 🚀 Instalación del CRM

### Método Automático

1. **Ejecutar instalación automática**
   ```
   http://localhost/CRM2/install.php
   ```
   - Este script creará automáticamente la base de datos
   - Instalará todas las tablas necesarias
   - Creará datos de ejemplo

2. **Verificar instalación**
   ```
   http://localhost/CRM2/test_connection.php
   ```

3. **Prueba simple**
   ```
   http://localhost/CRM2/test_simple.php
   ```

### Método Manual

1. **Ejecutar script SQL**
   - Abrir MySQL Workbench o phpMyAdmin
   - Ejecutar el contenido de `database.sql`

2. **Verificar tablas creadas**
   - usuarios
   - contactos
   - etiquetas
   - contacto_etiquetas
   - historial_cambios

## 🔐 Acceso al Sistema

**Credenciales por defecto:**
- Usuario: `admin`
- Contraseña: `admin123`

**URLs importantes:**
- Login: http://localhost/CRM2/login.php
- Dashboard: http://localhost/CRM2/dashboard.php
- Contactos: http://localhost/CRM2/contactos.php

## 🛠️ Solución de Problemas

### Error HTTP 500
- Verificar que PHP esté instalado: `php --version`
- Verificar extensiones: `php -m | findstr pdo`
- Revisar logs de error en `error.log`

### Error de Conexión
- Verificar que MySQL esté ejecutándose
- Verificar credenciales en `config.php`
- Probar conexión manual: `mysql -u crm_user -p`

### Tablas no existen
- Ejecutar `install.php`
- O ejecutar manualmente `database.sql`

## 📁 Estructura del Proyecto

```
CRM2/
├── config.php              # Configuración
├── database.sql            # Script de base de datos
├── install.php            # Instalación automática
├── test_connection.php    # Diagnóstico completo
├── test_simple.php       # Prueba básica
├── login.php             # Página de login
├── dashboard.php         # Panel principal
├── contactos.php         # Gestión de contactos
├── usuarios.php          # Gestión de usuarios
└── README_INSTALACION.md # Esta guía
```

## 🔄 Comandos Útiles

```bash
# Verificar PHP
php --version
php -m

# Iniciar servidor PHP (después de instalar PHP)
php -S localhost:8080

# Verificar MySQL
mysql --version
mysql -u root -p

# Ver logs de error
type error.log
```

## 📞 Soporte

Si continúa teniendo problemas:

1. Ejecute `test_simple.php` para diagnóstico básico
2. Ejecute `test_connection.php` para diagnóstico completo
3. Revise el archivo `error.log` para detalles específicos
4. Verifique que todos los requisitos estén instalados

---

**¡Una vez instalado PHP y MySQL, el sistema funcionará perfectamente!** 🎉